within FaultTriggering.Examples.ActuatorExample.Parts.Motors;
model Simple_ParameterFaults "example of a simple motor with faults"

extends Modelica.Electrical.Machines.Icons.TransientMachine;
  Modelica.Mechanics.Rotational.Sources.Torque motor
    annotation (Placement(transformation(extent={{10,-10},{30,10}})));
  Modelica.Mechanics.Rotational.Interfaces.Flange_b flange1 "Flange of shaft"
    annotation (Placement(transformation(extent={{88,-10},{108,10}})));
  Modelica.Mechanics.Rotational.Components.Inertia motorInertia(J=1e-3)
    annotation (Placement(transformation(extent={{44,-10},{64,10}})));
  Modelica.Blocks.Interfaces.RealOutput speed "Connector of Real output signal"
    annotation (Placement(transformation(extent={{96,-90},{116,-70}})));
  Modelica.Blocks.Math.Product motorTorque
    annotation (Placement(transformation(extent={{-30,-10},{-10,10}})));
  FaultSpeedSensor_ParamterFault
                     speedSensor(constBooleanFault=false)
    annotation (Placement(transformation(extent={{60,-90},{80,-70}})));
  Modelica.Blocks.Interfaces.RealInput torqueReference "motorTorqueReference"
                           annotation (Placement(transformation(extent={{-80,40},
            {-40,80}}), iconTransformation(extent={{-80,40},{-40,80}})));
  Modelica.Blocks.Sources.Constant bokenKt(k=0)
    annotation (Placement(transformation(extent={{-100,-90},{-80,-70}})));
  Modelica.Blocks.Sources.Constant halfBrokenKt(k=0.5)
    annotation (Placement(transformation(extent={{-100,-60},{-80,-40}})));
  Modelica.Blocks.Routing.Extractor kt_selection(nin=3)
    annotation (Placement(transformation(extent={{-40,-60},{-20,-40}})));
  Modelica.Blocks.Routing.Multiplex3 multiplex
    annotation (Placement(transformation(extent={{-70,-60},{-50,-40}})));
  Modelica.Blocks.Sources.Constant healthyKt(k=1)
    annotation (Placement(transformation(extent={{-100,-30},{-80,-10}})));
  FaultOutput.ConstantIntegerFault motorKtFault
    annotation (Placement(transformation(extent={{-60,-90},{-40,-70}})));
equation
  connect(motor.flange,motorInertia. flange_a) annotation (Line(
      points={{30,0},{44,0}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(motorInertia.flange_b, flange1) annotation (Line(
      points={{64,0},{98,0}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(motorTorque.y,motor. tau) annotation (Line(
      points={{-9,0},{8,0}},
      color={0,0,127},
      smooth=Smooth.None));

  connect(speedSensor.flange, motor.flange) annotation (Line(
      points={{59.8,-80},{38,-80},{38,0},{30,0}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(speedSensor.w, speed)      annotation (Line(
      points={{81,-80},{106,-80}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(motorTorque.u1, torqueReference)      annotation (Line(
      points={{-32,6},{-36,6},{-36,60},{-60,60}},
      color={0,0,127},
      pattern=LinePattern.None,
      smooth=Smooth.None));
  connect(halfBrokenKt.y,multiplex. u2[1])  annotation (Line(
      points={{-79,-50},{-72,-50}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(healthyKt.y,multiplex. u1[1])  annotation (Line(
      points={{-79,-20},{-76,-20},{-76,-43},{-72,-43}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(multiplex.u3[1],bokenKt. y)          annotation (Line(
      points={{-72,-57},{-76,-57},{-76,-80},{-79,-80}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(multiplex.y,kt_selection. u)
                                    annotation (Line(
      points={{-49,-50},{-42,-50}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(kt_selection.y, motorTorque.u2)
                                       annotation (Line(
      points={{-19,-50},{-16,-50},{-16,-30},{-38,-30},{-38,-6},{-32,-6}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(motorKtFault.y,kt_selection. index) annotation (Line(
      points={{-39,-80},{-30,-80},{-30,-62}},
      color={255,127,0},
      smooth=Smooth.None));
  annotation (Diagram(graphics={Rectangle(
          extent={{-2,32},{80,-38}},
          lineColor={0,0,255},
          fillColor={255,255,170},
          fillPattern=FillPattern.Solid), Text(
          extent={{80,20},{0,32}},
          lineColor={0,0,255},
          fillColor={255,255,170},
          fillPattern=FillPattern.Solid,
          textString="Motor")}), Icon(graphics={
                                        Text(
        extent={{-150,150},{150,110}},
        textString="%name",
        lineColor={0,0,255})}),
    Documentation(info="<html>
<p>Simplified motor model with efficiency drop fault (Motor Fault) and SpeedSensor fault.</p>
<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr>
<td><p><br/><img src=\"modelica://FaultTriggering/Resources/Documentation/Images/logo_dlr.png\"/></p></td>
<td><p><h4>Copyright &copy; DLR Institute of System Dynamics and Control </h4></p></td>
</tr>
</table>
</html>"));
end Simple_ParameterFaults;
